﻿using System;
using System.Collections.Generic;
using System.Linq;
using VA.TMP.DataModel;
using VA.TMP.Integration.VIMT.Vista.StateObject;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.Vista.PipelineSteps.GroupCancelAppointment
{
    public class GetFacilitiesStep : FilterBase<CancelGroupAppointmentStateObject>
    {
        public override void Execute(CancelGroupAppointmentStateObject state)
        {
            using (var srv = new Xrm(state.OrganizationServiceProxy))
            {
                //tsa is deprecated.  Need to get the pat/pro cacilities from the respective TMP Sites
                mcs_site patSite = new mcs_site();
                mcs_site proSite = new mcs_site();

                //patient
                if (state.ServiceAppointment.mcs_relatedsite != null)
                {
                    patSite = srv.mcs_siteSet.FirstOrDefault(pat => pat.Id == state.ServiceAppointment.mcs_relatedsite.Id);
                }
                if ((patSite.Id != null) && (patSite.Id != Guid.Empty))
                {
                    state.PatientFacility = srv.mcs_facilitySet.FirstOrDefault(f => f.Id == patSite.mcs_FacilityId.Id);
                }


                //provider
                if (state.ServiceAppointment.mcs_relatedprovidersite != null)
                {
                    proSite = srv.mcs_siteSet.FirstOrDefault(pro => pro.Id == state.ServiceAppointment.mcs_relatedprovidersite.Id);
                }

                if ((proSite.Id != null) && (proSite.Id != Guid.Empty))
                {
                    state.ProviderFacility = srv.mcs_facilitySet.FirstOrDefault(p => p.Id == proSite.mcs_FacilityId.Id);
                }


                //removed old code:
                //var tsa = srv.mcs_servicesSet.FirstOrDefault(t => t.Id == state.ServiceAppointment.mcs_relatedtsa.Id);
                //if(tsa.cvt_ProviderFacility != null)
                //    state.ProviderFacility = srv.mcs_facilitySet.FirstOrDefault(f => f.Id == tsa.cvt_ProviderFacility.Id);

                //var patSite = srv.mcs_siteSet.FirstOrDefault(s => s.Id == state.CrmAppointment.cvt_Site.Id);
                //state.PatientFacility = srv.mcs_facilitySet.FirstOrDefault(f => f.Id == patSite.mcs_FacilityId.Id);
            }
        }
    }
}
